package gov.va.med.mhv.usermgmt.service.impl;

import java.util.Collection;

import gov.va.med.mhv.usermgmt.bizobj.OrganizationAssembler;
import gov.va.med.mhv.usermgmt.bizobj.OrganizationBO;
import gov.va.med.mhv.usermgmt.enumeration.OrganizationTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.OrganizationCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.OrganizationServiceResponse;

import gov.va.med.mhv.usermgmt.service.OrganizationService;
import gov.va.med.mhv.usermgmt.transfer.OrganizationPK;

/**
 * Service implementation class for the Organization service
 * @see gov.va.med.mhv.usermgmt.service.OrganizationService
 */
public class OrganizationServiceImpl implements OrganizationService {

	/**
	 * Execute the GetOrganizationsByType service
	 * @see gov.va.med.mhv.usermgmt.service.OrganizationService#GetOrganizationsByType()
	 */
	public OrganizationCollectionServiceResponse getOrganizationsByType(OrganizationTypeEnumeration orgType) {
		OrganizationCollectionServiceResponse response = new OrganizationCollectionServiceResponse();
		
		Collection bizObjs = OrganizationBO.getOrganizationsOfType(orgType);
		Collection entities = OrganizationAssembler.getOrganizationCollection(bizObjs);
		response.addOrganizations(entities);
		
		return response;
	}

	public OrganizationServiceResponse getOrganization(Long orgId) {
		OrganizationServiceResponse response = new OrganizationServiceResponse();
		OrganizationBO bo = OrganizationBO.findByPrimaryKey(new OrganizationPK(orgId));
		response.setOrganization(bo.getOrganizationValues());
		return response;
	}

}